<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('pid')->unsigned()->index();
			$table->integer('data_limit')->unsigned();
			$table->integer('data_count')->unsigned();
			$table->integer('tags_limit')->unsigned();
			$table->string('token')->index();
			$table->timestamp('last_write')->index();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}