<?php

namespace App;

class PenilaianAtasan extends Eloquent {

	protected $table = 'penilaian_atasan';
	public $timestamps = true;

	public function jadwalLiquid()
	{
		return $this->belongsTo('App\JadwalLiquid', 'jadwal_liquid_id', 'id');
	}

	public function resolusiAtasan()
	{
		return $this->hasMany('App\ResolusiAtasan', 'penilaian_atasan_id', 'id');
	}

	public function pengukuranResolusi()
	{
		return $this->hasMany('App\PenilaianAtasan', 'penilaian_atasan_id', 'id');
	}

	public function user()
	{
		return $this->belongsTo('App\User', 'nip', 'nip');
	}

	public function feedback()
	{
		return $this->hasMany('App\Feedback', 'penilaian_atasan_id', 'id');
	}

}