<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWarehousesTable extends Migration {

	public function up()
	{
		Schema::create('warehouses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->tinyInteger('default');
			$table->string('slug', 64)->unique();
			$table->string('name', 32);
			$table->text('address');
		});
	}

	public function down()
	{
		Schema::drop('warehouses');
	}
}