<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminsTable extends Migration {

	public function up()
	{
		Schema::create('admins', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->string('email')->unique()->nullable();
			$table->string('mobile')->unique()->nullable();
			$table->string('password')->nullable();
			$table->enum('status', array('active', 'not_active'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('admins');
	}
}