<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('business_id')->references('id')->on('businesses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('influencer_id')->references('id')->on('influencers')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('business_id')->references('id')->on('businesses')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('businesses', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('businesses', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('businesses', function(Blueprint $table) {
			$table->foreign('subscription_id')->references('id')->on('subscriptions')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('businesses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('business_influencers_pivot', function(Blueprint $table) {
			$table->foreign('business_id')->references('id')->on('businesses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('business_id')->references('id')->on('businesses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign_influencer_pivot', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign_requests', function(Blueprint $table) {
			$table->foreign('business_id')->references('id')->on('businesses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaign_requests', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('connection_requests', function(Blueprint $table) {
			$table->foreign('business_id')->references('id')->on('businesses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('connection_requests', function(Blueprint $table) {
			$table->foreign('influencer_id')->references('id')->on('influencers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('connection_requests', function(Blueprint $table) {
			$table->foreign('requested_by_user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('influencers', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('influencers', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('influencers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('rated_by_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_business_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_campaign_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_influencer_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_business_id_foreign');
		});
		Schema::table('businesses', function(Blueprint $table) {
			$table->dropForeign('businesses_country_id_foreign');
		});
		Schema::table('businesses', function(Blueprint $table) {
			$table->dropForeign('businesses_state_id_foreign');
		});
		Schema::table('businesses', function(Blueprint $table) {
			$table->dropForeign('businesses_subscription_id_foreign');
		});
		Schema::table('businesses', function(Blueprint $table) {
			$table->dropForeign('businesses_user_id_foreign');
		});
		Schema::table('business_influencers_pivot', function(Blueprint $table) {
			$table->dropForeign('business_influencers_pivot_business_id_foreign');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_business_id_foreign');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_user_id_foreign');
		});
		Schema::table('campaign_influencer_pivot', function(Blueprint $table) {
			$table->dropForeign('campaign_influencer_pivot_campaign_id_foreign');
		});
		Schema::table('campaign_requests', function(Blueprint $table) {
			$table->dropForeign('campaign_requests_business_id_foreign');
		});
		Schema::table('campaign_requests', function(Blueprint $table) {
			$table->dropForeign('campaign_requests_campaign_id_foreign');
		});
		Schema::table('connection_requests', function(Blueprint $table) {
			$table->dropForeign('connection_requests_business_id_foreign');
		});
		Schema::table('connection_requests', function(Blueprint $table) {
			$table->dropForeign('connection_requests_influencer_id_foreign');
		});
		Schema::table('connection_requests', function(Blueprint $table) {
			$table->dropForeign('connection_requests_requested_by_user_id_foreign');
		});
		Schema::table('influencers', function(Blueprint $table) {
			$table->dropForeign('influencers_country_id_foreign');
		});
		Schema::table('influencers', function(Blueprint $table) {
			$table->dropForeign('influencers_state_id_foreign');
		});
		Schema::table('influencers', function(Blueprint $table) {
			$table->dropForeign('influencers_user_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_rated_by_user_id_foreign');
		});
	}
}