<?php

class ConnectionRequest extends Eloquent {

	protected $table = 'connection_requests';
	public $timestamps = true;
	protected $fillable = array('business_id', 'influencer_id', 'requested_type', 'requested_by_user_id', 'status', 'request_message');
	protected $visible = array('business_id', 'influencer_id', 'requested_type', 'requested_by_user_id', 'status', 'request_message');

	public function business()
	{
		return $this->belongsTo('Business');
	}

	public function influencer()
	{
		return $this->belongsTo('Influencer');
	}

	public function requestedByUser()
	{
		return $this->hasOne('Users');
	}

}