<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('banner', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('content_section')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('content_section_data', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('content_section')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('banner_data', function(Blueprint $table) {
			$table->foreign('banner_id')->references('id')->on('banner')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('membership_data_types', function(Blueprint $table) {
			$table->foreign('memberShip_type_id')->references('id')->on('membership_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permissions_membershipOptions', function(Blueprint $table) {
			$table->foreign('permision_id')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permissions_membershipOptions', function(Blueprint $table) {
			$table->foreign('membeship_option_id')->references('id')->on('membership_options')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bank_data', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('membership_options', function(Blueprint $table) {
			$table->foreign('membership_type_id')->references('id')->on('membership_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('album_category_data', function(Blueprint $table) {
			$table->foreign('album_category_id')->references('id')->on('album_category')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transactions_type', function(Blueprint $table) {
			$table->foreign('transactions_id')->references('id')->on('transactions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('membership_option_data', function(Blueprint $table) {
			$table->foreign('membership_option_id')->references('id')->on('membership_options')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('banner', function(Blueprint $table) {
			$table->dropForeign('banner_section_id_foreign');
		});
		Schema::table('content_section_data', function(Blueprint $table) {
			$table->dropForeign('content_section_data_section_id_foreign');
		});
		Schema::table('banner_data', function(Blueprint $table) {
			$table->dropForeign('banner_data_banner_id_foreign');
		});
		Schema::table('membership_data_types', function(Blueprint $table) {
			$table->dropForeign('membership_data_types_memberShip_type_id_foreign');
		});
		Schema::table('permissions_membershipOptions', function(Blueprint $table) {
			$table->dropForeign('permissions_membershipOptions_permision_id_foreign');
		});
		Schema::table('permissions_membershipOptions', function(Blueprint $table) {
			$table->dropForeign('permissions_membershipOptions_membeship_option_id_foreign');
		});
		Schema::table('bank_data', function(Blueprint $table) {
			$table->dropForeign('bank_data_bank_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_bank_id_foreign');
		});
		Schema::table('membership_options', function(Blueprint $table) {
			$table->dropForeign('membership_options_membership_type_id_foreign');
		});
		Schema::table('album_category_data', function(Blueprint $table) {
			$table->dropForeign('album_category_data_album_category_id_foreign');
		});
		Schema::table('transactions_type', function(Blueprint $table) {
			$table->dropForeign('transactions_type_transactions_id_foreign');
		});
		Schema::table('membership_option_data', function(Blueprint $table) {
			$table->dropForeign('membership_option_data_membership_option_id_foreign');
		});
	}
}