<?php

namespace models;

use Illuminate\Database\Eloquent\Model;

class City extends Model 
{

    protected $table = 'citys';
    public $timestamps = true;
    protected $fillable = array('name');

    public function towns()
    {
        return $this->hasMany('Town');
    }

    public function images()
    {
        return $this->morphOne('Images');
    }

    public function categories()
    {
        return $this->hasManyThrough('models\Category', 'cits_categors');
    }

}