<?php

namespace models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Owner extends Model 
{

    protected $table = 'owners';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function facility()
    {
        return $this->hasOne('Owner', 'owner_id');
    }

}