<?php

namespace models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Owner extends Eloquent {

	protected $table = 'owners';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function facility()
	{
		return $this->hasOne('Owner', 'owner_id');
	}

}