<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateComisionesDetalleTable extends Migration {

	public function up()
	{
		Schema::create('comisiones_detalle', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('comision_id')->unsigned();
			$table->integer('nivel')->unsigned();
			$table->bigInteger('distribuidor_id')->unsigned();
			$table->datetime('fechahora_pago');
			$table->enum('equipo', array('1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'))->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('comisiones_detalle');
	}
}