<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDistribuidoresTable extends Migration {

	public function up()
	{
		Schema::create('distribuidores', function(Blueprint $table) {
			$table->increments('id');
			$table->date('fecha_solicitud');
			$table->integer('user_id');
			$table->integer('padre_id')->nullable();
			$table->integer('organizacion_id')->unsigned()->nullable();
			$table->integer('equipo');
			$table->integer('equipos_activos');
			$table->integer('hijos');
			$table->string('nombre');
			$table->string('paterno');
			$table->string('materno');
			$table->string('calle');
			$table->string('numero');
			$table->string('colonia');
			$table->integer('entidad_id');
			$table->integer('municipio_id');
			$table->string('ciudad');
			$table->integer('codigo_postal')->unsigned();
			$table->string('sexo', 3);
			$table->date('fecha_nacimiento');
			$table->string('telefono_particular');
			$table->string('telefono_oficina');
			$table->string('telefono_celular');
			$table->string('curp', 18);
			$table->string('rfc', 13);
			$table->integer('cuenta_id')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('distribuidores');
	}
}