<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCuentasTable extends Migration {

	public function up()
	{
		Schema::create('cuentas', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('banco_id')->unsigned();
			$table->string('cuenta')->nullable();
			$table->string('clabe')->nullable();
			$table->boolean('activo')->nullable()->default(false);
			$table->boolean('preferido')->nullable()->default(false);
			$table->integer('tipocuenta_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('cuentas');
	}
}