<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PagoDetalle extends Model 
{

    protected $table = 'pagos_detalle';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('monto');

    public function tipoPago()
    {
        return $this->hasOne('App\TipoPago');
    }

    public function medioDePago()
    {
        return $this->hasOne('App\MediosDePago', 'medio_de_pago_id');
    }

}