<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Deal extends Model 
{

    protected $table = 'deals';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('shop_id', 'code', 'validity', 'quantity', 'description');

    public function images()
    {
        return $this->morphMany('App\Image', 'type');
    }

}