<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDealsTable extends Migration {

	public function up()
	{
		Schema::create('deals', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('shop_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->string('code');
			$table->timestamps();
			$table->integer('quantity')->nullable();
			$table->text('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('deals');
	}
}