<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 150);
			$table->string('country_code', 15);
			$table->integer('mobile');
			$table->string('email', 150)->nullable();
			$table->string('image', 150)->nullable();
			$table->string('company_name', 250)->nullable();
			$table->enum('is_active', array('0', '1'));
			$table->string('admin_company_verify', 250)->nullable();
			$table->enum('is_verified', array('0', '1'));
			$table->string('remember_token', 150)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}