<?php

namespace Notification;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Notification extends Model 
{

    protected $table = 'notifications';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'slug', 'message', 'image', 'is_read');

    public function getUser()
    {
        return $this->hasOne('User', 'user_id');
    }

    public function getTrip()
    {
        return $this->hasOne('Trip', 'trip_id');
    }

}