<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTripsTable extends Migration {

	public function up()
	{
		Schema::create('trips', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('driver_id');
			$table->integer('user_id');
			$table->decimal('pickup_from_lat', 10,5)->nullable();
			$table->float('pickup_from_long', 10,5)->nullable();
			$table->decimal('pickup_to_lat', 10,5)->nullable();
			$table->decimal('pickup_to_long', 10,5)->nullable();
			$table->string('location_from', 250)->nullable();
			$table->string('location_to', 250)->nullable();
			$table->string('company_name', 250)->nullable();
			$table->integer('type');
			$table->string('project_code', 250);
			$table->enum('is_scheduled', array('0', '1'));
			$table->integer('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('trips');
	}
}