<?php

namespace Driver;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Driver extends Eloquent {

	protected $table = 'driver_users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'country_code', 'mobile', 'email', 'image', 'grade', 'balance', 'remember_token');

	public function getGrade()
	{
		return $this->hasOne('DriverGrade', 'grade');
	}

}