<?php

namespace Payment;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Payment extends Eloquent {

	protected $table = 'payments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('trip_amount', 'waiting_time', 'total_amount');

	public function getUser()
	{
		return $this->hasOne('User', 'user_id');
	}

	public function getTrip()
	{
		return $this->hasOne('Trip', 'trip_id');
	}

}