<?php

namespace Trip;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Trip extends Eloquent {

	protected $table = 'trips';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('pickup_from_lat', 'pickup_from_long', 'pickup_to_lat', 'pickup_to_long', 'location_from', 'location_to', 'company_name', 'type', 'project_code', 'is_scheduled', 'status');

	public function getUser()
	{
		return $this->hasOne('User', 'cust_id');
	}

	public function getDriver()
	{
		return $this->hasOne('Driver', 'driver_id');
	}

	public function getTripType()
	{
		return $this->belongsTo('TripType', 'type');
	}

}