<?php

namespace UserDevice;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserDevice extends Eloquent {

	protected $table = 'user_devices';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_code', 'mobile', 'device_type', 'device_token', 'is_logout');

	public function getUser()
	{
		return $this->hasOne('User', 'user_id');
	}

}