<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoresTable extends Migration {

	public function up()
	{
		Schema::create('stores', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('phone', 15);
			$table->string('address', 255);
			$table->string('image', 255)->nullable();
			$table->string('views');
			$table->enum('active', array('active', 'deactivate'));
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('stores');
	}
}