<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id');
			$table->integer('restaurant_id');
			$table->double('cost', 255);
			$table->double('delivery_cost')->nullable();
			$table->double('total');
			$table->double('commission');
			$table->enum('status', array(''));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}