<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('utilisateurs', function(Blueprint $table) {
			$table->foreign('type_utilisateur_id')->references('id')->on('type_utilisateurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('utilisateurs_id')->references('id')->on('utilisateurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('type_clients_id')->references('id')->on('type_clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('abscences', function(Blueprint $table) {
			$table->foreign('utilisateurs_id')->references('id')->on('utilisateurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('maintenances', function(Blueprint $table) {
			$table->foreign('utilisateurs_id')->references('id')->on('utilisateurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('produits', function(Blueprint $table) {
			$table->foreign('utilisateurs_id')->references('id')->on('utilisateurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('nom_de_domaine', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('utilisateurs', function(Blueprint $table) {
			$table->dropForeign('utilisateurs_type_utilisateur_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_utilisateurs_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_type_clients_id_foreign');
		});
		Schema::table('abscences', function(Blueprint $table) {
			$table->dropForeign('abscences_utilisateurs_id_foreign');
		});
		Schema::table('maintenances', function(Blueprint $table) {
			$table->dropForeign('maintenances_utilisateurs_id_foreign');
		});
		Schema::table('produits', function(Blueprint $table) {
			$table->dropForeign('produits_utilisateurs_id_foreign');
		});
		Schema::table('nom_de_domaine', function(Blueprint $table) {
			$table->dropForeign('nom_de_domaine_package_id_foreign');
		});
	}
}