<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UnitSchedule extends Model 
{

    protected $table = 'unit_schedules';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('unit_id', 'name', 'set_on', 'set_to');
    protected $visible = array('unit_id', 'name', 'set_on', 'set_to');

    public function unit()
    {
        return $this->belongsTo('App\Unit');
    }

}