<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Song extends Model 
{

    protected $table = 'songs';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo('App\User');
    }

    public function type()
    {
        return $this->belongsTo('App\SongType');
    }

    public function genres()
    {
        return $this->belongsToMany('App\Genre');
    }

    public function language()
    {
        return $this->belongsTo('App\Language');
    }

    public function album()
    {
        return $this->belongsTo('App\Album');
    }

    public function artists()
    {
        return $this->belongsToMany('SongArtistRole', 'song_id');
    }

    public function videos()
    {
        return $this->hasMany('App\Video');
    }

}