<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->foreign('song_id')->references('id')->on('songs')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('songs', function(Blueprint $table) {
			$table->foreign('album_id')->references('id')->on('albums')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('songs', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('songs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('albums', function(Blueprint $table) {
			$table->foreign('album_type_id')->references('id')->on('album_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('song_artist_artistRole', function(Blueprint $table) {
			$table->foreign('song_id')->references('id')->on('songs')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('song_artist_artistRole', function(Blueprint $table) {
			$table->foreign('artist_id')->references('id')->on('artists')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('song_artist_artistRole', function(Blueprint $table) {
			$table->foreign('artist_role_id')->references('id')->on('artist_roles')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->dropForeign('videos_song_id_foreign');
		});
		Schema::table('videos', function(Blueprint $table) {
			$table->dropForeign('videos_user_id_foreign');
		});
		Schema::table('songs', function(Blueprint $table) {
			$table->dropForeign('songs_album_id_foreign');
		});
		Schema::table('songs', function(Blueprint $table) {
			$table->dropForeign('songs_language_id_foreign');
		});
		Schema::table('songs', function(Blueprint $table) {
			$table->dropForeign('songs_user_id_foreign');
		});
		Schema::table('albums', function(Blueprint $table) {
			$table->dropForeign('albums_album_type_id_foreign');
		});
		Schema::table('song_artist_artistRole', function(Blueprint $table) {
			$table->dropForeign('song_artist_artistRole_song_id_foreign');
		});
		Schema::table('song_artist_artistRole', function(Blueprint $table) {
			$table->dropForeign('song_artist_artistRole_artist_id_foreign');
		});
		Schema::table('song_artist_artistRole', function(Blueprint $table) {
			$table->dropForeign('song_artist_artistRole_artist_role_id_foreign');
		});
	}
}