<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('teacher_id')->unsigned()->index();
			$table->bigInteger('category_id')->unsigned()->index();
			$table->string('name');
			$table->string('slug');
			$table->string('price');
			$table->enum('status', array('review', 'approved'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}