<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDefaultRulesTable extends Migration {

	public function up()
	{
		Schema::create('default_rules', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('rule_category')->unsigned();
			$table->string('lable');
			$table->enum('type', array(''text'', ''range'', ''radio'', ''checkbox''));
			$table->text('help_text')->nullable();
			$table->string('defauly_value')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('default_rules');
	}
}