<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRostersTable extends Migration {

	public function up()
	{
		Schema::create('rosters', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('team_id')->unsigned();
			$table->integer('draftable_id')->unsigned();
			$table->string('lookupKey', 100);
			$table->tinyInteger('is_bench');
			$table->tinyInteger('is_starter');
			$table->tinyInteger('is_flex');
			$table->integer('order');
		});
	}

	public function down()
	{
		Schema::drop('rosters');
	}
}