<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('company_address', function(Blueprint $table) {
			$table->foreign('companies_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_address', function(Blueprint $table) {
			$table->foreign('country_code_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('links', function(Blueprint $table) {
			$table->foreign('companies_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('press_coverage', function(Blueprint $table) {
			$table->foreign('companies_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('company_address', function(Blueprint $table) {
			$table->dropForeign('company_address_companies_id_foreign');
		});
		Schema::table('company_address', function(Blueprint $table) {
			$table->dropForeign('company_address_country_code_id_foreign');
		});
		Schema::table('links', function(Blueprint $table) {
			$table->dropForeign('links_companies_id_foreign');
		});
		Schema::table('press_coverage', function(Blueprint $table) {
			$table->dropForeign('press_coverage_companies_id_foreign');
		});
	}
}