<?php

namespace App\Models;

class Covenant extends Eloquent {

	protected $table = 'covenants';
	public $timestamps = true;
	protected $fillable = array('covenant_number', 'covenant_name_id', 'office_id', 'employee_id', 'mobility', 'in_stock', 'covenant_stock_number');

	public function office()
	{
		return $this->belongsTo('App\Models\Office');
	}

	public function covenant_name()
	{
		return $this->belongsTo('App\Models\CovenantName');
	}

	public function employee()
	{
		return $this->belongsTo('App\Models\Employee');
	}

}