<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSocialLinksTable extends Migration {

	public function up()
	{
		Schema::create('social_links', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->bigIncrements('uuid');
			$table->integer('user_id')->unsigned();
			$table->string('type', 127);
			$table->string('url', 255);
			$table->integer('created_by')->unsigned();
			$table->integer('updated_by')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('social_links');
	}
}