<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    public function category()
    {
        return $this->belongsTo('ProductCategory');
    }

    public function rates()
    {
        return $this->hasMany('ProductRate');
    }

    public function store()
    {
        return $this->hasOne('Store');
    }

    public function currency()
    {
        return $this->belongsTo('Currency');
    }

}