<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderInfosTable extends Migration {

	public function up()
	{
		Schema::create('order_infos', function(Blueprint $table) {
			$table->increments('id');
			$table->json('car_class');
			$table->json('products');
			$table->double('min_price');
			$table->string('status');
			$table->double('max_price');
			$table->string('full_name');
			$table->integer('order_id')->unsigned();
			$table->string('quantity');
			$table->integer('total_distances');
		});
	}

	public function down()
	{
		Schema::drop('order_infos');
	}
}