<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCurriculumStagiairesTable extends Migration {

	public function up()
	{
		Schema::create('curriculum_stagiaires', function(Blueprint $table) {
			$table->string('curriculum_id')->unique()->primary();
			$table->string('nom_etablissement');
			$table->date('mois_annee_debut');
			$table->date('mois_annee_fin');
			$table->string('diplome_obtenu');
			$table->boolean('diplome_valide')->default(false );
			$table->string('stagiaire_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('curriculum_stagiaires');
	}
}