<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ShippingComany extends Eloquent {

	protected $table = 'shipping_companies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('name-slug');
	protected $fillable = array('name');

	public function products()
	{
		return $this->hasMany('ShippingProduct');
	}

}