<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ShippingPlace extends Eloquent {

	protected $table = 'shipping_places';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('shipping_product_id', 'name', 'name-slug', 'longitude', 'latitude', 'dropoff', 'pickup');

	public function products()
	{
		return $this->belongsToMany('ShippingProduct');
	}

	public function city()
	{
		return $this->hasOne('City');
	}

}