<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppointmentsTable extends Migration {

	public function up()
	{
		Schema::create('appointments', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('clinic_id')->unsigned();
			$table->bigInteger('doctor_id')->unsigned()->nullable();
			$table->string('client_name');
			$table->string('phone');
			$table->string('payment_type')->default('cash');
			$table->string('national_number');
			$table->enum('gender', array(''male'', ''female''));
			$table->string('status');
			$table->boolean('phone_verified')->default(0);
			$table->date('birthdate');
			$table->time('start_date');
			$table->time('end_date');
			$table->date('date');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('appointments');
	}
}