<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Form extends Eloquent {

	protected $table = 'forms';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('longitude', 'latitude', 'comment');

	public function type()
	{
		return $this->belongsTo('Type');
	}

	public function priority()
	{
		return $this->belongsTo('Priority');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function area()
	{
		return $this->belongsTo('Area');
	}

}