<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'Users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Images()
	{
		return $this->hasMany('Image');
	}

	public function Votes()
	{
		return $this->hasMany('Vote');
	}

	public function Friends()
	{
		return $this->hasMany('Friend');
	}

}