<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTable extends Migration {

	public function up()
	{
		Schema::create('Product', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('des');
			$table->string('details');
			$table->integer('cat_id')->unsigned();
			$table->string('photo_id');
			$table->decimal('price');
			$table->integer('quantity');
			$table->boolean('active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Product');
	}
}