<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('objectives');
			$table->datetime('date');
			$table->string('status');
			$table->string('type');
			$table->integer('account_id')->unsigned();
			$table->integer('project_id');
			$table->integer('deal_id');
			$table->integer('task_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}