<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagosTable extends Migration {

	public function up()
	{
		Schema::create('pagos', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email', 255);
			$table->integer('id_usuario');
			$table->smallInteger('pack_id');
			$table->string('price', 50);
			$table->string('pack_name', 100);
			$table->string('response_code', 10)->nullable();
			$table->string('metodo', 100);
			$table->enum('pago_terminado', array('si', 'no'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('pagos');
	}
}