<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('product_tags', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('product_tags', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('product_cards', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('point_product_images', function(Blueprint $table) {
			$table->foreign('point_product_id')->references('id')->on('point_products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('wallet_charges', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('wallet_charges', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('order_carts', function(Blueprint $table) {
			$table->foreign('cart_id')->references('id')->on('carts')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('order_carts', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('point_carts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('point_carts', function(Blueprint $table) {
			$table->foreign('point_product_id')->references('id')->on('point_products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('point_orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('point_order_carts', function(Blueprint $table) {
			$table->foreign('point_cart_id')->references('id')->on('point_carts')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('point_order_carts', function(Blueprint $table) {
			$table->foreign('point_order_id')->references('id')->on('point_orders')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('cart_cards', function(Blueprint $table) {
			$table->foreign('cart_id')->references('id')->on('carts')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('cart_cards', function(Blueprint $table) {
			$table->foreign('point_cart_id')->references('id')->on('point_carts')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('cart_cards', function(Blueprint $table) {
			$table->foreign('product_card_id')->references('id')->on('product_cards')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('loyalotys', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_category_id_foreign');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->dropForeign('product_images_product_id_foreign');
		});
		Schema::table('product_tags', function(Blueprint $table) {
			$table->dropForeign('product_tags_product_id_foreign');
		});
		Schema::table('product_tags', function(Blueprint $table) {
			$table->dropForeign('product_tags_tag_id_foreign');
		});
		Schema::table('product_cards', function(Blueprint $table) {
			$table->dropForeign('product_cards_product_id_foreign');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->dropForeign('favourites_user_id_foreign');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->dropForeign('favourites_product_id_foreign');
		});
		Schema::table('point_product_images', function(Blueprint $table) {
			$table->dropForeign('point_product_images_point_product_id_foreign');
		});
		Schema::table('wallet_charges', function(Blueprint $table) {
			$table->dropForeign('wallet_charges_user_id_foreign');
		});
		Schema::table('wallet_charges', function(Blueprint $table) {
			$table->dropForeign('wallet_charges_bank_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_user_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_user_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_product_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_bank_id_foreign');
		});
		Schema::table('order_carts', function(Blueprint $table) {
			$table->dropForeign('order_carts_cart_id_foreign');
		});
		Schema::table('order_carts', function(Blueprint $table) {
			$table->dropForeign('order_carts_order_id_foreign');
		});
		Schema::table('point_carts', function(Blueprint $table) {
			$table->dropForeign('point_carts_user_id_foreign');
		});
		Schema::table('point_carts', function(Blueprint $table) {
			$table->dropForeign('point_carts_point_product_id_foreign');
		});
		Schema::table('point_orders', function(Blueprint $table) {
			$table->dropForeign('point_orders_user_id_foreign');
		});
		Schema::table('point_order_carts', function(Blueprint $table) {
			$table->dropForeign('point_order_carts_point_cart_id_foreign');
		});
		Schema::table('point_order_carts', function(Blueprint $table) {
			$table->dropForeign('point_order_carts_point_order_id_foreign');
		});
		Schema::table('cart_cards', function(Blueprint $table) {
			$table->dropForeign('cart_cards_cart_id_foreign');
		});
		Schema::table('cart_cards', function(Blueprint $table) {
			$table->dropForeign('cart_cards_point_cart_id_foreign');
		});
		Schema::table('cart_cards', function(Blueprint $table) {
			$table->dropForeign('cart_cards_product_card_id_foreign');
		});
		Schema::table('loyalotys', function(Blueprint $table) {
			$table->dropForeign('loyalotys_user_id_foreign');
		});
	}
}