<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->string('total_price')->nullable();
			$table->enum('payment_method', array('visa', 'bank', 'mada', 'wallet'))->nullable();
			$table->bigInteger('bank_id')->unsigned()->nullable();
			$table->string('transfer_number')->nullable();
			$table->string('transfer_image')->nullable();
			$table->string('transfer_date')->nullable();
			$table->string('transfer_name')->nullable();
			$table->timestamps();
			$table->string('tax')->nullable();
			$table->enum('status', array('waiting', 'new', 'finished', 'cancel'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}