<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductCardsTable extends Migration {

	public function up()
	{
		Schema::create('product_cards', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('card_code')->nullable();
			$table->enum('available', array('true', 'false'))->nullable();
			$table->bigInteger('product_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product_cards');
	}
}