<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('is_import');
			$table->string('code', 255);
			$table->text('subject');
			$table->string('type', 255);
			$table->boolean('is_secret');
			$table->string('category_id', 255);
			$table->string('last_status_id', 255);
			$table->string('transaction_number');
			$table->integer('incoming_letter_number');
			$table->integer('without_incoming_number');
			$table->string('user_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}